import { Navbar } from "@/components/layout/Navbar";
import { Footer } from "@/components/layout/Footer";
import { getDictionary, Locale } from "@/lib/i18n";

export default async function LocaleLayout({
  children,
  params,
}: {
  children: React.ReactNode;
  params: { lang: Locale };
}) {
  const { lang } = params;
  const dictionary = await getDictionary(lang);

  return (
    <>
        <Navbar lang={lang} dict={dictionary.navigation} />
        <main className="flex-grow pt-16">
            {children}
        </main>
        <Footer lang={lang} dict={dictionary.navigation} />
    </>
  );
}
